<?php

/**

 * @package SB Employer Form

 */

/*

Plugin Name: SB Employer Form

Plugin URI: http://smithbates.com

Description: Custom Employer form.

Version: 1

Author: SmithBates

Author URI: http://smithbates.com

License: GPLv2 or later

*/


//SB Contact frontend

function sbEmp_function( $atts ){
	wp_enqueue_style('jquery-style', 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.8.2/themes/smoothness/jquery-ui.css');
	wp_enqueue_script( 'sbEmp-validate', plugins_url('includes/jquery.validate.min.js',__FILE__ ));
	wp_enqueue_style( 'sbEmp-style', plugins_url('includes/form.css',__FILE__ ));
	add_action( 'wp_footer', 'sb_employer_admin_javascript' );
	ob_start();
	include('includes/form.php');
	$output = ob_get_clean();
	return $output;
}
add_shortcode( 'sb_employer_form', 'sbEmp_function' );

add_action('wp_head','sb_employer_ajaxurl');

function sb_employer_ajaxurl() {

?>

<script type="text/javascript">

window.ajaxurl_emp = "<?php echo admin_url('admin-ajax.php'); ?>";

</script>

<?php

}

function sb_employer_admin_javascript() {
?>

<script type="text/javascript" >

jQuery(document).ready(function($) {

	$("#sbEmpForm").validate({
						errorPlacement: function(error, element) {
							error.insertAfter(element);
						}	,
						errorElement: "span",
						highlight: function(element, errorClass, validClass) {
							$(element).addClass(errorClass).removeClass(validClass);
							//$(element.form).find("label[for=" + element.id + "]").addClass(errorClass);
						},
						unhighlight: function(element, errorClass, validClass) {
							$(element).removeClass(errorClass).addClass(validClass);
							//$(element.form).find("label[for=" + element.id + "]").removeClass(errorClass);
						}
					});
					$.validator.messages.required = "";
					
				
					$("#sbEmpButton").click(function() {
						if($("#sbEmpForm").valid()) {
							//$("#sbEmpWrapper .thanksBox").show("slide",{direction:"right"});
							//$("#sbEmpForm").hide();
							$("#sbEmpWrapper .thanksBox").show();
							$("#sbEmpForm input, #sbEmpForm select, #sbEmpForm textarea").each(function() {
								$(this).attr("disabled","disabled");
							});
							
							$("#sbEmpButton").addClass("hideMe");
							
							var data = {
					
								action: "sbemp_get_data",
					
								datatype: "sbEmp",
					
								name: $("#form_name").val(),
								company: $("#form_company").val(),
								email: $("#form_email").val(),
								address: $("#form_address").val(),
								city: $("#form_city").val(),
								state: $("#form_state").val(),
								zip: $("#form_zip").val(),
								job: $("#form_job").val(),
								salary: $("#form_salary").val(),
								education: $("#form_education").val(),
								experience: $("#form_experience").val(),
								job_description: $("#form_job_description").val()
					
							};
					
					
					
							$.post(ajaxurl_emp, data, function(data) {
								
								if(data != "error") {	
									
									$("#sbEmpForm")[0].reset();
									$("#sbEmpForm input, #sbEmpForm select, #sbEmpForm textarea").each(function() {
										$(this).removeAttr("disabled");
									});
									thanksTimer();
								}
							});
						}
				
					});
					
					function thanksTimer() {
						setTimeout(function() {
								//$("#sbEmpSubmitting").addClass("hideMe");
								$("#sbEmpButton").removeClass("hideMe");
								//$("#sbEmpWrapper .thanksBox").hide("slide",{direction:"right"});
								$("#sbEmpWrapper .thanksBox").hide();
								$("#sbEmpForm").show();
							  
						}, 8000);
					}

} );

</script>



<?php



}

function sbemp_get_data_callback() {

	global $wpdb; 

	include(plugin_dir_path( __FILE__ ) . 'includes/data.php');
	
	die(); 



}
// allow ajax no priv and admin
add_action('wp_ajax_nopriv_sbemp_get_data', 'sbemp_get_data_callback');
add_action('wp_ajax_sbemp_get_data', 'sbemp_get_data_callback');


?>